/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TagManager {
    private static Set<String> GLOBAL_TAG_OPTIONS = new HashSet<String>();
    private static Map<String, Predicate<IAnchorBlock>> BLOCK_SPECIFIC_TAG_OPTIONS = new HashMap<String, Predicate<IAnchorBlock>>();

    public static void registerGlobalTagOption(String tag) {
        GLOBAL_TAG_OPTIONS.add(tag);
    }

    public static void registerSpecificTagOption(String tag, Predicate<IAnchorBlock> predicate) {
        Predicate storedPredicate = BLOCK_SPECIFIC_TAG_OPTIONS.getOrDefault(tag, null);
        if (storedPredicate == null) {
            BLOCK_SPECIFIC_TAG_OPTIONS.put(tag, predicate);
        } else {
            BLOCK_SPECIFIC_TAG_OPTIONS.put(tag, storedPredicate.or(predicate));
        }
    }

    public static Collection<String> getMatchingTagOptions(IAnchorBlock block) {
        return BLOCK_SPECIFIC_TAG_OPTIONS.entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(block)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public static Collection<String> getGlobalTagOptions() {
        return GLOBAL_TAG_OPTIONS;
    }

    static {
        GLOBAL_TAG_OPTIONS.add("groundlevel");
        GLOBAL_TAG_OPTIONS.add("invisible");
    }
}

