/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.IOPool;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;

public class UpdateSchematicPackCommand
extends AbstractCommand {
    public static final String commandName = "updateSchematicPack";
    private static final String PACK_NAME = "pack";

    private static int execute(CommandContext<CommandSourceStack> context) {
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        StructurePackMeta packMeta = StructurePacks.getStructurePack(packName);
        if (packMeta == null) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("Failed to find pack: " + packName)));
            return 0;
        }
        UpdateSchematicPackCommand.fixBlueprints(packMeta, (CommandSourceStack)context.getSource());
        return 1;
    }

    public static void fixBlueprints(StructurePackMeta packMeta, CommandSourceStack source) {
        CompletableFuture.supplyAsync(() -> {
            try (Stream<Path> paths = Files.walk(packMeta.getPath(), new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(".blueprint")).forEach(file -> {
                    block10: {
                        try {
                            int oldDataVersion;
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(Files.readAllBytes(file));
                            CompoundTag nbt = NbtIo.readCompressed((InputStream)inputStream, (NbtAccounter)NbtAccounter.unlimitedHeap());
                            inputStream.close();
                            int currentDataVersion = SharedConstants.getCurrentVersion().getDataVersion().getVersion();
                            int n = oldDataVersion = nbt.contains("mcversion") ? nbt.getInt("mcversion") : BlueprintUtil.DEFAULT_FIXER_IF_NOT_FOUND;
                            if (oldDataVersion == currentDataVersion) break block10;
                            Blueprint blueprint = BlueprintUtil.readBlueprintFromNBT(nbt, (HolderLookup.Provider)source.registryAccess());
                            if (blueprint == null) {
                                return;
                            }
                            CompoundTag newNbt = BlueprintUtil.writeBlueprintToNBT(blueprint);
                            Path schematicPath = file.subpath(2, file.getNameCount());
                            Path output = Minecraft.getInstance().gameDirectory.toPath().resolve("blueprints").resolve(schematicPath.toString());
                            output.getParent().toFile().mkdirs();
                            output.toFile().createNewFile();
                            try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
                                NbtIo.writeCompressed((CompoundTag)newNbt, (OutputStream)outputstream);
                            }
                            catch (IOException e) {
                                source.sendSystemMessage((Component)Component.literal((String)("Error saving blueprint:  " + packMeta.getName() + ":" + String.valueOf(file) + String.valueOf(e))));
                                return;
                            }
                            source.sendSystemMessage((Component)Component.literal((String)("Updated blueprint: " + String.valueOf(schematicPath))));
                        }
                        catch (IOException e) {
                            source.sendSystemMessage((Component)Component.literal((String)("Error loading blueprint: " + packMeta.getName() + ":" + String.valueOf(file) + String.valueOf(e))));
                        }
                    }
                });
            }
            catch (Exception e) {
                source.sendSystemMessage((Component)Component.literal((String)("Error loading folder: " + packMeta.getName() + String.valueOf(e))));
            }
            return null;
        }, IOPool.getExecutor()).whenComplete((a, b) -> source.sendSystemMessage((Component)Component.literal((String)("Finished updating schematics in pack: " + packMeta.getName()))));
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)UpdateSchematicPackCommand.newLiteral(commandName).then(UpdateSchematicPackCommand.newArgument(PACK_NAME, StringArgumentType.greedyString()).suggests((context, builder) -> {
            for (StructurePackMeta packMeta : StructurePacks.getPackMetas()) {
                builder.suggest(packMeta.getName());
            }
            return builder.buildFuture();
        }).executes(UpdateSchematicPackCommand::execute));
    }
}

