/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.ISpecialBlockPickItem;
import com.ldtteam.structurize.api.Utils;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.component.CapturedBlock;
import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.items.ItemStackTooltip;
import com.ldtteam.structurize.network.messages.AbsorbBlockMessage;
import com.ldtteam.structurize.tag.ModTags;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemTagSubstitution
extends BlockItem
implements ISpecialBlockPickItem {
    public ItemTagSubstitution() {
        super((Block)ModBlocks.blockTagSubstitution.get(), new Item.Properties().component(ModDataComponents.CAPTURED_BLOCK, (Object)CapturedBlock.EMPTY));
    }

    @Override
    @NotNull
    public InteractionResult onBlockPick(@NotNull Player player, @NotNull ItemStack stack, @Nullable BlockPos pos, boolean ctrlKey) {
        if (pos == null) {
            if (!player.level().isClientSide()) {
                CapturedBlock.EMPTY.writeToItemStack(stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = player.level().getBlockState(pos);
        if (blockstate.is(BlockTags.WITHER_IMMUNE)) {
            if (!player.level().isClientSide()) {
                CapturedBlock.EMPTY.writeToItemStack(stack);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.level().isClientSide()) {
            ItemStack pick = this.getPickedBlock(player, pos, blockstate);
            new AbsorbBlockMessage(pos, pick).sendToServer();
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    private ItemStack getPickedBlock(@NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState blockstate) {
        return blockstate.getCloneItemStack(Minecraft.getInstance().hitResult, (LevelReader)player.level(), pos, player);
    }

    public void onAbsorbBlock(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull BlockPos pos, @NotNull ItemStack absorbItem) {
        CapturedBlock replacement;
        BlockState blockstate = player.level().getBlockState(pos);
        BlockEntity blockentity = player.level().getBlockEntity(pos);
        if (blockentity instanceof BlockEntityTagSubstitution) {
            BlockEntityTagSubstitution blockception = (BlockEntityTagSubstitution)blockentity;
            replacement = blockception.getReplacement();
        } else {
            if (!this.isAllowed(blockentity)) {
                Utils.playErrorSound((Player)player);
                return;
            }
            replacement = new CapturedBlock(blockstate, blockentity, (HolderLookup.Provider)player.level().registryAccess(), absorbItem);
        }
        replacement.writeToItemStack(stack);
    }

    private boolean isAllowed(@Nullable BlockEntity blockentity) {
        if (blockentity == null) {
            return true;
        }
        HolderSet.Named tag = (HolderSet.Named)BuiltInRegistries.BLOCK_ENTITY_TYPE.getTag(ModTags.SUBSTITUTION_ABSORB_WHITELIST).get();
        return tag.contains((Holder)blockentity.getType().builtInRegistryHolder());
    }

    public Component getHighlightTip(@NotNull ItemStack stack, @NotNull Component displayName) {
        ItemStack absorbed = CapturedBlock.readFromItemStack(stack).itemStack();
        if (!absorbed.isEmpty()) {
            return Component.empty().append(super.getHighlightTip(stack, displayName)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append(absorbed.getHoverName());
        }
        return super.getHighlightTip(stack, displayName);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        ItemStack absorbedItem = CapturedBlock.readFromItemStack(stack).itemStack();
        if (!absorbedItem.isEmpty()) {
            return Optional.of(new ItemStackTooltip(absorbedItem));
        }
        return super.getTooltipImage(stack);
    }
}

