/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.tag.ModTags;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.registries.GameData;
import org.jetbrains.annotations.Nullable;

public final class BlockUtils {
    private static final Set<Block> trueSolidBlocks = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<BiPredicate<Block, BlockState>> FREE_TO_PLACE_BLOCKS = Arrays.asList((block, iBlockState) -> block.equals(Blocks.AIR), (block, iBlockState) -> BlockUtils.isLiquidOnlyBlock(iBlockState.getBlock()), (block, iBlockState) -> BlockUtils.isWater(block.defaultBlockState()), (block, iBlockState) -> block instanceof LeavesBlock, (block, iBlockState) -> block instanceof DoublePlantBlock, (block, iBlockState) -> block.equals(Blocks.GRASS_BLOCK), (block, iBlockState) -> block instanceof DoorBlock && iBlockState != null && (Boolean)iBlockState.getValue((Property)BooleanProperty.create((String)"upper")) != false);

    private BlockUtils() {
    }

    public static void checkOrInit() {
        if (trueSolidBlocks.isEmpty()) {
            BuiltInRegistries.BLOCK.stream().filter(BlockUtils::canBlockSurviveWithoutSupport).filter(block -> !block.defaultBlockState().canBeReplaced() && block.hasCollision && !(block instanceof Fallable) && !block.defaultBlockState().isAir() && !(block instanceof LiquidBlock) && !block.builtInRegistryHolder().is(ModTags.WEAK_SOLID_BLOCKS)).forEach(trueSolidBlocks::add);
        }
    }

    public static BlockState getSubstitutionBlockAtWorld(Level level, BlockPos location, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        BlockState result = BlockUtils.getWorldgenBlock(level, location, virtualBlocks);
        if (result != null && result.getBlock() == Blocks.POWDER_SNOW) {
            result = Blocks.SNOW_BLOCK.defaultBlockState();
        } else if (!(result != null && BlockUtils.isAnySolid(result) && result.getBlock() != Blocks.BEDROCK || (result = BlockUtils.getDefaultBlockForLevel(level, null)) != null && BlockUtils.isAnySolid(result) && result.getBlock() != Blocks.STONE)) {
            result = Blocks.DIRT.defaultBlockState();
        }
        return result;
    }

    @Nullable
    public static BlockState getWorldgenBlock(Level level, BlockPos location, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkGenerator generator = serverLevel.getChunkSource().getGenerator();
            if (generator instanceof NoiseBasedChunkGenerator) {
                BlockState bs;
                int tempY;
                NoiseBasedChunkGenerator chunkGenerator = (NoiseBasedChunkGenerator)generator;
                NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)chunkGenerator.generatorSettings().value();
                ChunkAccess chunk = serverLevel.getChunk(location);
                SurfaceRules.Context ctx = new SurfaceRules.Context(serverLevel.getChunkSource().randomState().surfaceSystem(), serverLevel.getChunkSource().randomState(), chunk, chunk.getOrCreateNoiseChunk(c -> BlockUtils.createNoiseBiome(serverLevel, chunkGenerator, c)), arg_0 -> ((BiomeManager)serverLevel.getBiomeManager()).getBiome(arg_0), serverLevel.registryAccess().registryOrThrow(Registries.BIOME), new WorldGenerationContext((ChunkGenerator)chunkGenerator, (LevelHeightAccessor)serverLevel));
                int locX = location.getX();
                int locY = location.getY();
                int locZ = location.getZ();
                int stoneDepthAbove = 1;
                int stoneDepthBelow = DimensionType.WAY_BELOW_MIN_Y;
                int waterHeight = Integer.MIN_VALUE;
                BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos(locX, locY, locZ);
                for (tempY = locY + 1; tempY <= chunk.getMaxBuildHeight() + 1; ++tempY) {
                    temp.setY(tempY);
                    BlockState blockState = bs = virtualBlocks == null ? chunk.getBlockState((BlockPos)temp) : Objects.requireNonNullElseGet(virtualBlocks.apply((BlockPos)temp), () -> chunk.getBlockState((BlockPos)temp));
                    if (bs.isAir()) break;
                    if (!bs.getFluidState().isEmpty()) {
                        waterHeight = tempY + 1;
                    }
                    ++stoneDepthAbove;
                }
                for (tempY = locY - 1; tempY >= chunk.getMinBuildHeight() - 1; --tempY) {
                    temp.setY(tempY);
                    BlockState blockState = bs = virtualBlocks == null ? chunk.getBlockState((BlockPos)temp) : Objects.requireNonNullElseGet(virtualBlocks.apply((BlockPos)temp), () -> chunk.getBlockState((BlockPos)temp));
                    if (!bs.isAir() && bs.getFluidState().isEmpty()) continue;
                    stoneDepthBelow = tempY + 1;
                    break;
                }
                stoneDepthBelow = locY - stoneDepthBelow + 1;
                ctx.updateXZ(locX, locZ);
                ctx.updateY(stoneDepthAbove, stoneDepthBelow, waterHeight, locX, locY, locZ);
                return ((SurfaceRules.SurfaceRule)generatorSettings.surfaceRule().apply((Object)ctx)).tryApply(locX, locY, locZ);
            }
            if (generator instanceof FlatLevelSource) {
                FlatLevelSource chunkGenerator = (FlatLevelSource)generator;
                List layers = chunkGenerator.settings().getLayers();
                int locY = location.getY() - serverLevel.getMinBuildHeight();
                if (locY >= 0 && locY < layers.size()) {
                    return (BlockState)layers.get(locY);
                }
            }
        }
        return null;
    }

    private static NoiseChunk createNoiseBiome(ServerLevel serverLevel, NoiseBasedChunkGenerator chunkGenerator, ChunkAccess chunk) {
        OurWorldGenRegion worldGenRegion = new OurWorldGenRegion(serverLevel, ChunkPyramid.GENERATION_PYRAMID.getStepTo(ChunkStatus.SURFACE), chunk);
        return chunkGenerator.createNoiseChunk(chunk, serverLevel.structureManager().forWorldGenRegion((WorldGenRegion)worldGenRegion), Blender.of((WorldGenRegion)worldGenRegion), serverLevel.getChunkSource().randomState());
    }

    public static boolean isWater(BlockState iBlockState) {
        return iBlockState.getBlock() == Blocks.WATER;
    }

    @Deprecated(forRemoval=true, since="1.21")
    private static Item getItem(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block.equals(Blocks.LAVA)) {
            return Items.LAVA_BUCKET;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = ((CropBlock)block).getCloneItemStack(null, null, blockState);
            if (stack != null) {
                return stack.getItem();
            }
            return Items.WHEAT_SEEDS;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return BlockUtils.getItemFromBlock(Blocks.DIRT);
        }
        if (block instanceof FireBlock) {
            return Items.FLINT_AND_STEEL;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.FLOWER_POT;
        }
        if (block == Blocks.BAMBOO_SAPLING) {
            return Items.BAMBOO;
        }
        return BlockUtils.getItemFromBlock(block);
    }

    @Deprecated(forRemoval=true, since="1.21")
    private static Item getItemFromBlock(Block block) {
        return (Item)GameData.getBlockItemMap().get(block);
    }

    public static boolean areBlockStatesEqual(BlockState structureState, BlockState worldState, Predicate<BlockState> shallReplace, boolean fancy, BiPredicate<BlockState, BlockState> specialEqualRule, CompoundTag tileEntityData, BlockEntity worldEntity) {
        if (structureState == null || worldState == null) {
            return true;
        }
        Block structureBlock = structureState.getBlock();
        Block worldBlock = worldState.getBlock();
        if (fancy && structureBlock == ModBlocks.blockSubstitution.get()) {
            return true;
        }
        if (worldState.equals(structureState)) {
            if (tileEntityData == null) {
                return true;
            }
            if (worldEntity == null) {
                return false;
            }
            if (worldEntity instanceof MateriallyTexturedBlockEntity) {
                MateriallyTexturedBlockEntity mtbe = (MateriallyTexturedBlockEntity)worldEntity;
                if (tileEntityData.contains("textureData")) {
                    return mtbe.getTextureData().equals(((Pair)MaterialTextureData.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tileEntityData.get("textureData")).getOrThrow()).getFirst());
                }
            }
            return true;
        }
        if (worldEntity instanceof MateriallyTexturedBlockEntity) {
            return false;
        }
        if (fancy) {
            if (structureBlock instanceof AirBlock && worldBlock instanceof AirBlock) {
                return true;
            }
            if (structureBlock == Blocks.DIRT && worldState.is(BlockTags.DIRT)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockSolidSubstitution.get() && !shallReplace.test(worldState)) {
                return true;
            }
            if (structureBlock == ModBlocks.blockFluidSubstitution.get() && (worldState.getFluidState().isSource() || !worldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && BlockUtils.isAnySolid(worldState)) || worldBlock == ModBlocks.blockFluidSubstitution.get() && (structureState.getFluidState().isSource() || !structureState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && BlockUtils.isAnySolid(structureState))) {
                return true;
            }
        }
        return specialEqualRule.test(structureState, worldState);
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        return BlockUtils.getBlockStateFromStack(stack, Blocks.AIR.defaultBlockState());
    }

    public static BlockState getBlockStateFromStack(ItemStack stack, BlockState def) {
        if (stack.getItem() == Items.AIR) {
            return Blocks.AIR.defaultBlockState();
        }
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            return bucket.content.defaultFluidState().createLegacyBlock();
        }
        item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock().defaultBlockState();
        }
        return def;
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquid = (LiquidBlock)block;
            return new ItemStack((ItemLike)liquid.fluid.getBucket(), 1);
        }
        Item item = BlockUtils.getItem(blockState);
        if (item != Items.AIR && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)blockState.getBlock(), 1);
    }

    public static boolean doBlocksMatch(ItemStack block, ServerLevel world, BlockPos position) {
        BlockState blockState = world.getBlockState(position);
        BlockEntity tileEntity = world.getBlockEntity(position);
        boolean isMatch = false;
        if (block.getItem() == Items.AIR && blockState.isAir()) {
            isMatch = true;
        } else {
            IPlacementHandler handler = PlacementHandlers.getHandler((Level)world, BlockPos.ZERO, blockState);
            List<ItemStack> itemList = handler.getRequiredItems((Level)world, position, blockState, tileEntity == null ? null : tileEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess()), true);
            if (!itemList.isEmpty() && ItemStackUtils.compareItemStacksIgnoreStackSize(itemList.get(0), block)) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    public static void handleCorrectBlockPlacement(Level world, FakePlayer fakePlayer, ItemStack itemStack, BlockState blockState, BlockPos here) {
        ItemStack stackToPlace = itemStack.copy();
        Item item = stackToPlace.getItem();
        stackToPlace.setCount(stackToPlace.getMaxStackSize());
        if (item instanceof AirItem) {
            world.removeBlock(here, false);
        } else if (item instanceof BlockItem) {
            Block targetBlock = ((BlockItem)item).getBlock();
            BlockState newState = BlockUtils.copyFirstCommonBlockStateProperties(targetBlock.defaultBlockState(), blockState);
            if (newState == null) {
                fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stackToPlace);
                if (stackToPlace.is(ItemTags.BEDS) && blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                    fakePlayer.setYRot((float)(((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).get2DDataValue() * 90));
                }
                if ((newState = targetBlock.getStateForPlacement(new BlockPlaceContext(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), itemStack.getItem() instanceof BedItem ? Direction.UP : Direction.NORTH, here, true))))) == null) {
                    return;
                }
            }
            world.setBlock(here, Blocks.COBBLESTONE.defaultBlockState(), 2);
            world.setBlock(here, newState, 3);
            BlockEntity blockEntity = world.getBlockEntity(here);
            if (blockEntity != null) {
                blockEntity.applyComponentsFromItemStack(stackToPlace);
            }
            targetBlock.setPlacedBy(world, here, newState, (LivingEntity)fakePlayer, stackToPlace);
        } else if (item instanceof BucketItem) {
            Block sourceBlock = blockState.getBlock();
            BucketItem bucket = (BucketItem)item;
            Fluid fluid = bucket.content;
            if (sourceBlock instanceof LiquidBlockContainer) {
                LiquidBlockContainer liquidContainer = (LiquidBlockContainer)sourceBlock;
                if (liquidContainer.canPlaceLiquid((Player)fakePlayer, (BlockGetter)world, here, blockState, fluid)) {
                    liquidContainer.placeLiquid((LevelAccessor)world, here, blockState, fluid.defaultFluidState());
                    bucket.checkExtraContent(null, world, stackToPlace, here);
                }
            } else {
                world.setBlock(here, Blocks.COBBLESTONE.defaultBlockState(), 2);
                world.setBlock(here, fluid.defaultFluidState().createLegacyBlock(), 3);
                bucket.checkExtraContent(null, world, stackToPlace, here);
            }
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Cannot handle placing of {0} instead of {1}?!", itemStack.toString(), blockState.toString()));
        }
    }

    public static void removeFluid(Level world, BlockPos pos) {
        BucketPickup bucketBlock;
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if ((!(block instanceof BucketPickup) || (bucketBlock = (BucketPickup)block).pickupBlock(null, (LevelAccessor)world, pos, state).isEmpty()) && block instanceof LiquidBlock) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static BlockState getFluidForDimension(Level world) {
        NoiseBasedChunkGenerator chunkGenerator;
        BlockState defaultFluid;
        ServerLevel serverLevel;
        ChunkGenerator generator;
        if (world instanceof ServerLevel && (generator = (serverLevel = (ServerLevel)world).getChunkSource().getGenerator()) instanceof NoiseBasedChunkGenerator && !(defaultFluid = ((NoiseGeneratorSettings)(chunkGenerator = (NoiseBasedChunkGenerator)generator).generatorSettings().value()).defaultFluid()).getFluidState().isEmpty()) {
            return defaultFluid;
        }
        return world == null || !world.dimensionType().ultraWarm() ? Blocks.WATER.defaultBlockState() : Blocks.LAVA.defaultBlockState();
    }

    public static BlockState getDefaultBlockForLevel(Level level, BlockState defaultValue) {
        ServerLevel serverLevel;
        ChunkGenerator generator;
        if (level instanceof ServerLevel && (generator = (serverLevel = (ServerLevel)level).getChunkSource().getGenerator()) instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator chunkGenerator = (NoiseBasedChunkGenerator)generator;
            return ((NoiseGeneratorSettings)chunkGenerator.generatorSettings().value()).defaultBlock();
        }
        return defaultValue;
    }

    public static List<ItemStack> getBlockDrops(Level world, BlockPos coords, int fortune, ItemStack stack) {
        if (!(world instanceof ServerLevel)) {
            throw new IllegalArgumentException("trying to get block drops at client side?!");
        }
        ServerLevel serverLevel = (ServerLevel)world;
        return world.getBlockState(coords).getDrops(new LootParams.Builder(serverLevel).withLuck((float)fortune).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atLowerCornerOf((Vec3i)coords)).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)world.getBlockEntity(coords)).withParameter(LootContextParams.TOOL, (Object)stack));
    }

    public static BlockState copyFirstCommonBlockStateProperties(BlockState target, BlockState propertiesOrigin) {
        BlockState newState = target;
        for (Property property : propertiesOrigin.getProperties()) {
            if (!target.hasProperty(property)) continue;
            newState = BlockUtils.copyProperty(propertiesOrigin, newState, property);
        }
        return newState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.setValue(property, from.getValue(property));
    }

    public static boolean canBlockFloatInAir(BlockState blockState) {
        if (blockState.getBlock() instanceof LeavesBlock) {
            return !blockState.isRandomlyTicking();
        }
        return trueSolidBlocks.contains(blockState.getBlock());
    }

    public static boolean isLiquidOnlyBlock(BlockState blockState) {
        return blockState.liquid() || BlockUtils.isLiquidOnlyBlock(blockState.getBlock());
    }

    public static boolean isLiquidOnlyBlock(Block block) {
        return block instanceof LiquidBlock || block instanceof BubbleColumnBlock;
    }

    public static boolean isWeakSolidBlock(BlockState blockState) {
        if (blockState.getBlock() instanceof LeavesBlock) {
            return blockState.isRandomlyTicking();
        }
        if (blockState.canBeReplaced() || !blockState.getBlock().hasCollision) {
            return false;
        }
        Block block = blockState.getBlock();
        return block.builtInRegistryHolder().is(ModTags.WEAK_SOLID_BLOCKS) && BlockUtils.canBlockSurviveWithoutSupport(block);
    }

    public static boolean canBlockSurviveWithoutSupport(Block block) {
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return true;
        }
        try {
            return block.defaultBlockState().canSurvive(null, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isGoodFullBlock(BlockState block) {
        try {
            return block.getShape(null, null) == Shapes.block();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAnySolid(BlockState blockState) {
        return BlockUtils.canBlockFloatInAir(blockState) || BlockUtils.isWeakSolidBlock(blockState);
    }

    public static boolean isGoodFloorBlock(BlockState blockState) {
        return BlockUtils.isGoodFullBlock(blockState) && !blockState.is(ModTags.UNSUITABLE_SOLID_FOR_PLACEHOLDER) || blockState.is(ModTags.GOOD_SOLID_FOR_PLACEHOLDER);
    }

    public static SolidnessInfo getSolidInfo(BlockState blockState) {
        return new SolidnessInfo(BlockUtils.canBlockFloatInAir(blockState), BlockUtils.isWeakSolidBlock(blockState));
    }

    private static class OurWorldGenRegion
    extends WorldGenRegion {
        private final StaticCache2D<ChunkAccess> chunks;
        private final ServerLevel level;

        private OurWorldGenRegion(ServerLevel level, ChunkStep step, ChunkAccess chunk) {
            super(level, null, step, chunk);
            int chunkX = chunk.getPos().x;
            int chunkZ = chunk.getPos().z;
            int chunkRange = step.accumulatedDependencies().getRadius();
            this.level = level;
            this.chunks = StaticCache2D.create((int)chunkX, (int)chunkZ, (int)chunkRange, (x, z) -> {
                ChunkAccess surroundingChunk = level.getChunk(x, z, ChunkStatus.SURFACE);
                if (surroundingChunk instanceof ImposterProtoChunk) {
                    ImposterProtoChunk imposterProtoChunk = (ImposterProtoChunk)surroundingChunk;
                    surroundingChunk = new ImposterProtoChunk(imposterProtoChunk.getWrapped(), true);
                } else if (surroundingChunk instanceof LevelChunk) {
                    LevelChunk levelChunk = (LevelChunk)surroundingChunk;
                    surroundingChunk = new ImposterProtoChunk(levelChunk, true);
                }
                return surroundingChunk;
            });
        }

        public boolean destroyBlock(BlockPos p_9550_, boolean p_9551_, @Nullable Entity p_9552_, int p_9553_) {
            return false;
        }

        public boolean ensureCanWrite(BlockPos p_181031_) {
            return false;
        }

        public boolean setBlock(BlockPos p_9539_, BlockState p_9540_, int p_9541_, int p_9542_) {
            return false;
        }

        public boolean addFreshEntity(Entity p_9580_) {
            return false;
        }

        public boolean removeBlock(BlockPos p_9547_, boolean p_9548_) {
            return false;
        }

        public ChunkAccess getChunk(int p_9514_, int p_9515_, ChunkStatus p_331853_, boolean p_9517_) {
            return (ChunkAccess)this.chunks.get(p_9514_, p_9515_);
        }

        public boolean hasChunk(int p_9574_, int p_9575_) {
            return this.level.hasChunk(p_9574_, p_9575_);
        }

        public boolean isOldChunkAround(ChunkPos pos, int radius) {
            int minX = pos.x - radius;
            int maxX = pos.x + radius;
            int minZ = pos.z - radius;
            int maxZ = pos.z + radius;
            return this.chunks.contains(minX, minZ) && this.chunks.contains(minX, maxZ) && this.chunks.contains(maxX, minZ) && this.chunks.contains(maxX, maxZ);
        }
    }

    public record SolidnessInfo(boolean canFloatInAir, boolean isWeakSolid) {
        public boolean isAnySolid() {
            return this.canFloatInAir || this.isWeakSolid;
        }
    }
}

