/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.cycling;

import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.controllers.cycling.CyclingListController;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.util.OptionEnum;

public class EnumController<T extends Enum<T>>
extends CyclingListController<T> {
    public static <T extends Enum<T>> Function<T, Component> getDefaultFormatter() {
        return value -> {
            if (value instanceof NameableEnum) {
                NameableEnum nameableEnum = (NameableEnum)((Object)value);
                return nameableEnum.getDisplayName();
            }
            if (value instanceof OptionEnum) {
                OptionEnum translatableOption = (OptionEnum)value;
                return translatableOption.getCaption();
            }
            return Component.literal((String)value.toString());
        };
    }

    public EnumController(Option<T> option, Class<T> enumClass) {
        this(option, EnumController.getDefaultFormatter(), (Enum[])enumClass.getEnumConstants());
    }

    public EnumController(Option<T> option, Function<T, Component> valueFormatter, T[] availableValues) {
        super(option, Arrays.asList(availableValues), valueFormatter);
    }

    public static <T extends Enum<T>> EnumController<T> createInternal(Option<T> option, ValueFormatter<T> formatter, T[] values) {
        return new EnumController(option, formatter::format, values);
    }
}

